package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SimplifiedApplication(
    name: Option[String] = None,
    version: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SimplifiedApplication = {
    import SimplifiedApplication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SimplifiedApplication
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SimplifiedApplication.ReadOnly =
    zio.aws.emr.model.SimplifiedApplication.wrap(buildAwsValue())
}
object SimplifiedApplication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SimplifiedApplication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SimplifiedApplication =
      zio.aws.emr.model.SimplifiedApplication(
        name.map(value => value),
        version.map(value => value)
      )
    def name: Option[String]
    def version: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SimplifiedApplication
  ) extends zio.aws.emr.model.SimplifiedApplication.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SimplifiedApplication
  ): zio.aws.emr.model.SimplifiedApplication.ReadOnly = new Wrapper(impl)
}
