package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutAutoTerminationPolicyRequest(
    clusterId: ClusterId,
    autoTerminationPolicy: Option[zio.aws.emr.model.AutoTerminationPolicy] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest = {
    import PutAutoTerminationPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        autoTerminationPolicy.map(value => value.buildAwsValue())
      )(_.autoTerminationPolicy)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PutAutoTerminationPolicyRequest.ReadOnly =
    zio.aws.emr.model.PutAutoTerminationPolicyRequest.wrap(buildAwsValue())
}
object PutAutoTerminationPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PutAutoTerminationPolicyRequest =
      zio.aws.emr.model.PutAutoTerminationPolicyRequest(
        clusterId,
        autoTerminationPolicy.map(value => value.asEditable)
      )
    def clusterId: ClusterId
    def autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getAutoTerminationPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoTerminationPolicy", autoTerminationPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest
  ) extends zio.aws.emr.model.PutAutoTerminationPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val autoTerminationPolicy
        : Option[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] = scala
      .Option(impl.autoTerminationPolicy())
      .map(value => zio.aws.emr.model.AutoTerminationPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest
  ): zio.aws.emr.model.PutAutoTerminationPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
