package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OnDemandCapacityReservationOptions(
    usageStrategy: Option[
      zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy
    ] = None,
    capacityReservationPreference: Option[
      zio.aws.emr.model.OnDemandCapacityReservationPreference
    ] = None,
    capacityReservationResourceGroupArn: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions = {
    import OnDemandCapacityReservationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions
      .builder()
      .optionallyWith(usageStrategy.map(value => value.unwrap))(_.usageStrategy)
      .optionallyWith(capacityReservationPreference.map(value => value.unwrap))(
        _.capacityReservationPreference
      )
      .optionallyWith(
        capacityReservationResourceGroupArn.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.capacityReservationResourceGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly =
    zio.aws.emr.model.OnDemandCapacityReservationOptions.wrap(buildAwsValue())
}
object OnDemandCapacityReservationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OnDemandCapacityReservationOptions =
      zio.aws.emr.model.OnDemandCapacityReservationOptions(
        usageStrategy.map(value => value),
        capacityReservationPreference.map(value => value),
        capacityReservationResourceGroupArn.map(value => value)
      )
    def usageStrategy
        : Option[zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy]
    def capacityReservationPreference
        : Option[zio.aws.emr.model.OnDemandCapacityReservationPreference]
    def capacityReservationResourceGroupArn: Option[XmlStringMaxLen256]
    def getUsageStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy
    ] = AwsError.unwrapOptionField("usageStrategy", usageStrategy)
    def getCapacityReservationPreference: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandCapacityReservationPreference
    ] = AwsError.unwrapOptionField(
      "capacityReservationPreference",
      capacityReservationPreference
    )
    def getCapacityReservationResourceGroupArn
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "capacityReservationResourceGroupArn",
      capacityReservationResourceGroupArn
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions
  ) extends zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly {
    override val usageStrategy
        : Option[zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy] =
      scala
        .Option(impl.usageStrategy())
        .map(value =>
          zio.aws.emr.model.OnDemandCapacityReservationUsageStrategy.wrap(value)
        )
    override val capacityReservationPreference
        : Option[zio.aws.emr.model.OnDemandCapacityReservationPreference] =
      scala
        .Option(impl.capacityReservationPreference())
        .map(value =>
          zio.aws.emr.model.OnDemandCapacityReservationPreference.wrap(value)
        )
    override val capacityReservationResourceGroupArn
        : Option[XmlStringMaxLen256] = scala
      .Option(impl.capacityReservationResourceGroupArn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions
  ): zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly =
    new Wrapper(impl)
}
