package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Marker, XmlString, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStepsRequest(
    clusterId: ClusterId,
    stepStates: Option[Iterable[zio.aws.emr.model.StepState]] = None,
    stepIds: Option[Iterable[XmlString]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStepsRequest = {
    import ListStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStepsRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        stepStates.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.stepStatesWithStrings)
      .optionallyWith(
        stepIds.map(value =>
          value.map { item =>
            XmlString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepIds)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStepsRequest.ReadOnly =
    zio.aws.emr.model.ListStepsRequest.wrap(buildAwsValue())
}
object ListStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStepsRequest =
      zio.aws.emr.model.ListStepsRequest(
        clusterId,
        stepStates.map(value => value),
        stepIds.map(value => value),
        marker.map(value => value)
      )
    def clusterId: ClusterId
    def stepStates: Option[List[zio.aws.emr.model.StepState]]
    def stepIds: Option[List[XmlString]]
    def marker: Option[Marker]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getStepStates: ZIO[Any, AwsError, List[zio.aws.emr.model.StepState]] =
      AwsError.unwrapOptionField("stepStates", stepStates)
    def getStepIds: ZIO[Any, AwsError, List[XmlString]] =
      AwsError.unwrapOptionField("stepIds", stepIds)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStepsRequest
  ) extends zio.aws.emr.model.ListStepsRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val stepStates: Option[List[zio.aws.emr.model.StepState]] = scala
      .Option(impl.stepStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.StepState.wrap(item)
        }.toList
      )
    override val stepIds: Option[List[XmlString]] = scala
      .Option(impl.stepIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlString(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStepsRequest
  ): zio.aws.emr.model.ListStepsRequest.ReadOnly = new Wrapper(impl)
}
