package zio.aws.emr.model
import zio.aws.emr.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComputeLimits(
    unitType: zio.aws.emr.model.ComputeLimitsUnitType,
    minimumCapacityUnits: Integer,
    maximumCapacityUnits: Integer,
    maximumOnDemandCapacityUnits: Option[Integer] = None,
    maximumCoreCapacityUnits: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ComputeLimits = {
    import ComputeLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ComputeLimits
      .builder()
      .unitType(unitType.unwrap)
      .minimumCapacityUnits(
        Integer.unwrap(minimumCapacityUnits): java.lang.Integer
      )
      .maximumCapacityUnits(
        Integer.unwrap(maximumCapacityUnits): java.lang.Integer
      )
      .optionallyWith(
        maximumOnDemandCapacityUnits.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maximumOnDemandCapacityUnits)
      .optionallyWith(
        maximumCoreCapacityUnits.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maximumCoreCapacityUnits)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ComputeLimits.ReadOnly =
    zio.aws.emr.model.ComputeLimits.wrap(buildAwsValue())
}
object ComputeLimits {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ComputeLimits] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ComputeLimits =
      zio.aws.emr.model.ComputeLimits(
        unitType,
        minimumCapacityUnits,
        maximumCapacityUnits,
        maximumOnDemandCapacityUnits.map(value => value),
        maximumCoreCapacityUnits.map(value => value)
      )
    def unitType: zio.aws.emr.model.ComputeLimitsUnitType
    def minimumCapacityUnits: Integer
    def maximumCapacityUnits: Integer
    def maximumOnDemandCapacityUnits: Option[Integer]
    def maximumCoreCapacityUnits: Option[Integer]
    def getUnitType
        : ZIO[Any, Nothing, zio.aws.emr.model.ComputeLimitsUnitType] =
      ZIO.succeed(unitType)
    def getMinimumCapacityUnits: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(minimumCapacityUnits)
    def getMaximumCapacityUnits: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(maximumCapacityUnits)
    def getMaximumOnDemandCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "maximumOnDemandCapacityUnits",
        maximumOnDemandCapacityUnits
      )
    def getMaximumCoreCapacityUnits: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maximumCoreCapacityUnits", maximumCoreCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ComputeLimits
  ) extends zio.aws.emr.model.ComputeLimits.ReadOnly {
    override val unitType: zio.aws.emr.model.ComputeLimitsUnitType =
      zio.aws.emr.model.ComputeLimitsUnitType.wrap(impl.unitType())
    override val minimumCapacityUnits: Integer =
      zio.aws.emr.model.primitives.Integer(impl.minimumCapacityUnits())
    override val maximumCapacityUnits: Integer =
      zio.aws.emr.model.primitives.Integer(impl.maximumCapacityUnits())
    override val maximumOnDemandCapacityUnits: Option[Integer] = scala
      .Option(impl.maximumOnDemandCapacityUnits())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val maximumCoreCapacityUnits: Option[Integer] = scala
      .Option(impl.maximumCoreCapacityUnits())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ComputeLimits
  ): zio.aws.emr.model.ComputeLimits.ReadOnly = new Wrapper(impl)
}
