package zio.aws.emr.model
import zio.aws.emr.model.primitives.Date
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ClusterTimeline(
    creationDateTime: Option[Date] = None,
    readyDateTime: Option[Date] = None,
    endDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ClusterTimeline = {
    import ClusterTimeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ClusterTimeline
      .builder()
      .optionallyWith(
        creationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(readyDateTime.map(value => Date.unwrap(value): Instant))(
        _.readyDateTime
      )
      .optionallyWith(endDateTime.map(value => Date.unwrap(value): Instant))(
        _.endDateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ClusterTimeline.ReadOnly =
    zio.aws.emr.model.ClusterTimeline.wrap(buildAwsValue())
}
object ClusterTimeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ClusterTimeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ClusterTimeline =
      zio.aws.emr.model.ClusterTimeline(
        creationDateTime.map(value => value),
        readyDateTime.map(value => value),
        endDateTime.map(value => value)
      )
    def creationDateTime: Option[Date]
    def readyDateTime: Option[Date]
    def endDateTime: Option[Date]
    def getCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getReadyDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("readyDateTime", readyDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ClusterTimeline
  ) extends zio.aws.emr.model.ClusterTimeline.ReadOnly {
    override val creationDateTime: Option[Date] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val readyDateTime: Option[Date] = scala
      .Option(impl.readyDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val endDateTime: Option[Date] = scala
      .Option(impl.endDateTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ClusterTimeline
  ): zio.aws.emr.model.ClusterTimeline.ReadOnly = new Wrapper(impl)
}
