package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicyStateChangeReason(
    code: Option[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode] =
      None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason = {
    import AutoScalingPolicyStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly =
    zio.aws.emr.model.AutoScalingPolicyStateChangeReason.wrap(buildAwsValue())
}
object AutoScalingPolicyStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AutoScalingPolicyStateChangeReason =
      zio.aws.emr.model.AutoScalingPolicyStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ) extends zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly {
    override val code
        : Option[zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode] =
      scala
        .Option(impl.code())
        .map(value =>
          zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode.wrap(value)
        )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason
  ): zio.aws.emr.model.AutoScalingPolicyStateChangeReason.ReadOnly =
    new Wrapper(impl)
}
