package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReleaseLabelFilter(
    prefix: Option[String] = None,
    application: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ReleaseLabelFilter = {
    import ReleaseLabelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(application.map(value => value: java.lang.String))(
        _.application
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ReleaseLabelFilter.ReadOnly =
    zio.aws.emr.model.ReleaseLabelFilter.wrap(buildAwsValue())
}
object ReleaseLabelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ReleaseLabelFilter =
      zio.aws.emr.model.ReleaseLabelFilter(
        prefix.map(value => value),
        application.map(value => value)
      )
    def prefix: Option[String]
    def application: Option[String]
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getApplication: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("application", application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ) extends zio.aws.emr.model.ReleaseLabelFilter.ReadOnly {
    override val prefix: Option[String] =
      scala.Option(impl.prefix()).map(value => value: String)
    override val application: Option[String] =
      scala.Option(impl.application()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ReleaseLabelFilter
  ): zio.aws.emr.model.ReleaseLabelFilter.ReadOnly = new Wrapper(impl)
}
