package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceFleetStateChangeReason(
    code: Option[zio.aws.emr.model.InstanceFleetStateChangeReasonCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason = {
    import InstanceFleetStateChangeReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly =
    zio.aws.emr.model.InstanceFleetStateChangeReason.wrap(buildAwsValue())
}
object InstanceFleetStateChangeReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceFleetStateChangeReason =
      zio.aws.emr.model.InstanceFleetStateChangeReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.emr.model.InstanceFleetStateChangeReasonCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.InstanceFleetStateChangeReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason
  ) extends zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly {
    override val code
        : Option[zio.aws.emr.model.InstanceFleetStateChangeReasonCode] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.emr.model.InstanceFleetStateChangeReasonCode.wrap(value)
      )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceFleetStateChangeReason
  ): zio.aws.emr.model.InstanceFleetStateChangeReason.ReadOnly = new Wrapper(
    impl
  )
}
