package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStudiosResponse(
    studios: Option[Iterable[zio.aws.emr.model.StudioSummary]] = None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudiosResponse = {
    import ListStudiosResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudiosResponse
      .builder()
      .optionallyWith(
        studios.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studios)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudiosResponse.ReadOnly =
    zio.aws.emr.model.ListStudiosResponse.wrap(buildAwsValue())
}
object ListStudiosResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudiosResponse =
      zio.aws.emr.model.ListStudiosResponse(
        studios.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def studios: Option[List[zio.aws.emr.model.StudioSummary.ReadOnly]]
    def marker: Option[Marker]
    def getStudios
        : ZIO[Any, AwsError, List[zio.aws.emr.model.StudioSummary.ReadOnly]] =
      AwsError.unwrapOptionField("studios", studios)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ) extends zio.aws.emr.model.ListStudiosResponse.ReadOnly {
    override val studios
        : Option[List[zio.aws.emr.model.StudioSummary.ReadOnly]] = scala
      .Option(impl.studios())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.StudioSummary.wrap(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ): zio.aws.emr.model.ListStudiosResponse.ReadOnly = new Wrapper(impl)
}
