package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  BooleanObject,
  WholeNumber,
  InstanceType,
  NonNegativeDouble
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceTypeSpecification(
    instanceType: Option[InstanceType] = None,
    weightedCapacity: Option[WholeNumber] = None,
    bidPrice: Option[XmlStringMaxLen256] = None,
    bidPriceAsPercentageOfOnDemandPrice: Option[NonNegativeDouble] = None,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None,
    ebsBlockDevices: Option[Iterable[zio.aws.emr.model.EbsBlockDevice]] = None,
    ebsOptimized: Option[BooleanObject] = None,
    customAmiId: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceTypeSpecification = {
    import InstanceTypeSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
      .builder()
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        weightedCapacity.map(value => WholeNumber.unwrap(value): Integer)
      )(_.weightedCapacity)
      .optionallyWith(
        bidPrice.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.bidPrice)
      .optionallyWith(
        bidPriceAsPercentageOfOnDemandPrice.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.bidPriceAsPercentageOfOnDemandPrice)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsBlockDevices)
      .optionallyWith(
        ebsOptimized.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.ebsOptimized)
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceTypeSpecification.ReadOnly =
    zio.aws.emr.model.InstanceTypeSpecification.wrap(buildAwsValue())
}
object InstanceTypeSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceTypeSpecification =
      zio.aws.emr.model.InstanceTypeSpecification(
        instanceType.map(value => value),
        weightedCapacity.map(value => value),
        bidPrice.map(value => value),
        bidPriceAsPercentageOfOnDemandPrice.map(value => value),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        customAmiId.map(value => value)
      )
    def instanceType: Option[InstanceType]
    def weightedCapacity: Option[WholeNumber]
    def bidPrice: Option[XmlStringMaxLen256]
    def bidPriceAsPercentageOfOnDemandPrice: Option[NonNegativeDouble]
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def ebsBlockDevices: Option[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]]
    def ebsOptimized: Option[BooleanObject]
    def customAmiId: Option[XmlStringMaxLen256]
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getWeightedCapacity: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getBidPrice: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getBidPriceAsPercentageOfOnDemandPrice
        : ZIO[Any, AwsError, NonNegativeDouble] = AwsError.unwrapOptionField(
      "bidPriceAsPercentageOfOnDemandPrice",
      bidPriceAsPercentageOfOnDemandPrice
    )
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getEbsBlockDevices
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      AwsError.unwrapOptionField("ebsBlockDevices", ebsBlockDevices)
    def getEbsOptimized: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ) extends zio.aws.emr.model.InstanceTypeSpecification.ReadOnly {
    override val instanceType: Option[InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val weightedCapacity: Option[WholeNumber] = scala
      .Option(impl.weightedCapacity())
      .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val bidPrice: Option[XmlStringMaxLen256] = scala
      .Option(impl.bidPrice())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val bidPriceAsPercentageOfOnDemandPrice
        : Option[NonNegativeDouble] = scala
      .Option(impl.bidPriceAsPercentageOfOnDemandPrice())
      .map(value => zio.aws.emr.model.primitives.NonNegativeDouble(value))
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val ebsBlockDevices
        : Option[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] = scala
      .Option(impl.ebsBlockDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.EbsBlockDevice.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[BooleanObject] = scala
      .Option(impl.ebsOptimized())
      .map(value => zio.aws.emr.model.primitives.BooleanObject(value))
    override val customAmiId: Option[XmlStringMaxLen256] = scala
      .Option(impl.customAmiId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceTypeSpecification
  ): zio.aws.emr.model.InstanceTypeSpecification.ReadOnly = new Wrapper(impl)
}
