package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceType, InstanceFleetId, InstanceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Instance(
    id: Option[InstanceId] = None,
    ec2InstanceId: Option[InstanceId] = None,
    publicDnsName: Option[String] = None,
    publicIpAddress: Option[String] = None,
    privateDnsName: Option[String] = None,
    privateIpAddress: Option[String] = None,
    status: Option[zio.aws.emr.model.InstanceStatus] = None,
    instanceGroupId: Option[String] = None,
    instanceFleetId: Option[InstanceFleetId] = None,
    market: Option[zio.aws.emr.model.MarketType] = None,
    instanceType: Option[InstanceType] = None,
    ebsVolumes: Option[Iterable[zio.aws.emr.model.EbsVolume]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Instance
      .builder()
      .optionallyWith(
        id.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ec2InstanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.ec2InstanceId)
      .optionallyWith(publicDnsName.map(value => value: java.lang.String))(
        _.publicDnsName
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(instanceGroupId.map(value => value: java.lang.String))(
        _.instanceGroupId
      )
      .optionallyWith(
        instanceFleetId.map(value =>
          InstanceFleetId.unwrap(value): java.lang.String
        )
      )(_.instanceFleetId)
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        ebsVolumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsVolumes)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Instance.ReadOnly =
    zio.aws.emr.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Instance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Instance = zio.aws.emr.model.Instance(
      id.map(value => value),
      ec2InstanceId.map(value => value),
      publicDnsName.map(value => value),
      publicIpAddress.map(value => value),
      privateDnsName.map(value => value),
      privateIpAddress.map(value => value),
      status.map(value => value.asEditable),
      instanceGroupId.map(value => value),
      instanceFleetId.map(value => value),
      market.map(value => value),
      instanceType.map(value => value),
      ebsVolumes.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[InstanceId]
    def ec2InstanceId: Option[InstanceId]
    def publicDnsName: Option[String]
    def publicIpAddress: Option[String]
    def privateDnsName: Option[String]
    def privateIpAddress: Option[String]
    def status: Option[zio.aws.emr.model.InstanceStatus.ReadOnly]
    def instanceGroupId: Option[String]
    def instanceFleetId: Option[InstanceFleetId]
    def market: Option[zio.aws.emr.model.MarketType]
    def instanceType: Option[InstanceType]
    def ebsVolumes: Option[List[zio.aws.emr.model.EbsVolume.ReadOnly]]
    def getId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("id", id)
    def getEc2InstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getInstanceGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceGroupId", instanceGroupId)
    def getInstanceFleetId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("instanceFleetId", instanceFleetId)
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getEbsVolumes
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsVolume.ReadOnly]] =
      AwsError.unwrapOptionField("ebsVolumes", ebsVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Instance
  ) extends zio.aws.emr.model.Instance.ReadOnly {
    override val id: Option[InstanceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceId(value))
    override val ec2InstanceId: Option[InstanceId] = scala
      .Option(impl.ec2InstanceId())
      .map(value => zio.aws.emr.model.primitives.InstanceId(value))
    override val publicDnsName: Option[String] =
      scala.Option(impl.publicDnsName()).map(value => value: String)
    override val publicIpAddress: Option[String] =
      scala.Option(impl.publicIpAddress()).map(value => value: String)
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val status: Option[zio.aws.emr.model.InstanceStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.InstanceStatus.wrap(value))
    override val instanceGroupId: Option[String] =
      scala.Option(impl.instanceGroupId()).map(value => value: String)
    override val instanceFleetId: Option[InstanceFleetId] = scala
      .Option(impl.instanceFleetId())
      .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val market: Option[zio.aws.emr.model.MarketType] = scala
      .Option(impl.market())
      .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val instanceType: Option[InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val ebsVolumes
        : Option[List[zio.aws.emr.model.EbsVolume.ReadOnly]] = scala
      .Option(impl.ebsVolumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.EbsVolume.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Instance
  ): zio.aws.emr.model.Instance.ReadOnly = new Wrapper(impl)
}
