package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsBlockDevice(
    volumeSpecification: Option[zio.aws.emr.model.VolumeSpecification] = None,
    device: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.EbsBlockDevice = {
    import EbsBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.EbsBlockDevice
      .builder()
      .optionallyWith(volumeSpecification.map(value => value.buildAwsValue()))(
        _.volumeSpecification
      )
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.EbsBlockDevice.ReadOnly =
    zio.aws.emr.model.EbsBlockDevice.wrap(buildAwsValue())
}
object EbsBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.EbsBlockDevice =
      zio.aws.emr.model.EbsBlockDevice(
        volumeSpecification.map(value => value.asEditable),
        device.map(value => value)
      )
    def volumeSpecification
        : Option[zio.aws.emr.model.VolumeSpecification.ReadOnly]
    def device: Option[String]
    def getVolumeSpecification
        : ZIO[Any, AwsError, zio.aws.emr.model.VolumeSpecification.ReadOnly] =
      AwsError.unwrapOptionField("volumeSpecification", volumeSpecification)
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ) extends zio.aws.emr.model.EbsBlockDevice.ReadOnly {
    override val volumeSpecification
        : Option[zio.aws.emr.model.VolumeSpecification.ReadOnly] = scala
      .Option(impl.volumeSpecification())
      .map(value => zio.aws.emr.model.VolumeSpecification.wrap(value))
    override val device: Option[String] =
      scala.Option(impl.device()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ): zio.aws.emr.model.EbsBlockDevice.ReadOnly = new Wrapper(impl)
}
