package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Command(
    name: Option[String] = None,
    scriptPath: Option[String] = None,
    args: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Command = {
    import Command.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Command
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(scriptPath.map(value => value: java.lang.String))(
        _.scriptPath
      )
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Command.ReadOnly =
    zio.aws.emr.model.Command.wrap(buildAwsValue())
}
object Command {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Command] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Command = zio.aws.emr.model.Command(
      name.map(value => value),
      scriptPath.map(value => value),
      args.map(value => value)
    )
    def name: Option[String]
    def scriptPath: Option[String]
    def args: Option[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScriptPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scriptPath", scriptPath)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Command
  ) extends zio.aws.emr.model.Command.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val scriptPath: Option[String] =
      scala.Option(impl.scriptPath()).map(value => value: String)
    override val args: Option[List[String]] = scala
      .Option(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Command
  ): zio.aws.emr.model.Command.ReadOnly = new Wrapper(impl)
}
