package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait AutoScalingPolicyStateChangeReasonCode {
  def unwrap: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode
}
object AutoScalingPolicyStateChangeReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode
  ): zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode = value match {
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.USER_REQUEST =>
      val r = USER_REQUEST
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.PROVISION_FAILURE =>
      val r = PROVISION_FAILURE
      r
    case software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.CLEANUP_FAILURE =>
      val r = CLEANUP_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_REQUEST
      extends zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.USER_REQUEST
  }
  case object PROVISION_FAILURE
      extends zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.PROVISION_FAILURE
  }
  case object CLEANUP_FAILURE
      extends zio.aws.emr.model.AutoScalingPolicyStateChangeReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode =
      software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReasonCode.CLEANUP_FAILURE
  }
}
