package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlStringMaxLen256, XmlString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PlacementType(
    availabilityZone: Option[XmlString] = None,
    availabilityZones: Option[Iterable[XmlStringMaxLen256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PlacementType = {
    import PlacementType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PlacementType
      .builder()
      .optionallyWith(
        availabilityZone.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.availabilityZone)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PlacementType.ReadOnly =
    zio.aws.emr.model.PlacementType.wrap(buildAwsValue())
}
object PlacementType {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.PlacementType] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PlacementType =
      zio.aws.emr.model.PlacementType(
        availabilityZone.map(value => value),
        availabilityZones.map(value => value)
      )
    def availabilityZone: Option[XmlString]
    def availabilityZones: Option[List[XmlStringMaxLen256]]
    def getAvailabilityZone: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZones: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PlacementType
  ) extends zio.aws.emr.model.PlacementType.ReadOnly {
    override val availabilityZone: Option[XmlString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val availabilityZones: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PlacementType
  ): zio.aws.emr.model.PlacementType.ReadOnly = new Wrapper(impl)
}
