package zio.aws.emr.model
import zio.aws.emr.model.primitives.StepId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelStepsInfo(
    stepId: Option[StepId] = None,
    status: Option[zio.aws.emr.model.CancelStepsRequestStatus] = None,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CancelStepsInfo = {
    import CancelStepsInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CancelStepsInfo
      .builder()
      .optionallyWith(
        stepId.map(value => StepId.unwrap(value): java.lang.String)
      )(_.stepId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CancelStepsInfo.ReadOnly =
    zio.aws.emr.model.CancelStepsInfo.wrap(buildAwsValue())
}
object CancelStepsInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CancelStepsInfo =
      zio.aws.emr.model.CancelStepsInfo(
        stepId.map(value => value),
        status.map(value => value),
        reason.map(value => value)
      )
    def stepId: Option[StepId]
    def status: Option[zio.aws.emr.model.CancelStepsRequestStatus]
    def reason: Option[String]
    def getStepId: ZIO[Any, AwsError, StepId] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.CancelStepsRequestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ) extends zio.aws.emr.model.CancelStepsInfo.ReadOnly {
    override val stepId: Option[StepId] = scala
      .Option(impl.stepId())
      .map(value => zio.aws.emr.model.primitives.StepId(value))
    override val status: Option[zio.aws.emr.model.CancelStepsRequestStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.emr.model.CancelStepsRequestStatus.wrap(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsInfo
  ): zio.aws.emr.model.CancelStepsInfo.ReadOnly = new Wrapper(impl)
}
