package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StudioSummary(
    studioId: Option[XmlStringMaxLen256] = None,
    name: Option[XmlStringMaxLen256] = None,
    vpcId: Option[XmlStringMaxLen256] = None,
    description: Option[XmlStringMaxLen256] = None,
    url: Option[XmlStringMaxLen256] = None,
    authMode: Option[zio.aws.emr.model.AuthMode] = None,
    creationTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.StudioSummary = {
    import StudioSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.StudioSummary
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        vpcId.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        url.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.StudioSummary.ReadOnly =
    zio.aws.emr.model.StudioSummary.wrap(buildAwsValue())
}
object StudioSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.StudioSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.StudioSummary =
      zio.aws.emr.model.StudioSummary(
        studioId.map(value => value),
        name.map(value => value),
        vpcId.map(value => value),
        description.map(value => value),
        url.map(value => value),
        authMode.map(value => value),
        creationTime.map(value => value)
      )
    def studioId: Option[XmlStringMaxLen256]
    def name: Option[XmlStringMaxLen256]
    def vpcId: Option[XmlStringMaxLen256]
    def description: Option[XmlStringMaxLen256]
    def url: Option[XmlStringMaxLen256]
    def authMode: Option[zio.aws.emr.model.AuthMode]
    def creationTime: Option[Date]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getVpcId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getUrl: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("url", url)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.emr.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.StudioSummary
  ) extends zio.aws.emr.model.StudioSummary.ReadOnly {
    override val studioId: Option[XmlStringMaxLen256] = scala
      .Option(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val vpcId: Option[XmlStringMaxLen256] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val description: Option[XmlStringMaxLen256] = scala
      .Option(impl.description())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val url: Option[XmlStringMaxLen256] = scala
      .Option(impl.url())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val authMode: Option[zio.aws.emr.model.AuthMode] = scala
      .Option(impl.authMode())
      .map(value => zio.aws.emr.model.AuthMode.wrap(value))
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.StudioSummary
  ): zio.aws.emr.model.StudioSummary.ReadOnly = new Wrapper(impl)
}
