package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait StepState {
  def unwrap: software.amazon.awssdk.services.emr.model.StepState
}
object StepState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.StepState
  ): zio.aws.emr.model.StepState = value match {
    case software.amazon.awssdk.services.emr.model.StepState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.StepState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.emr.model.StepState.CANCEL_PENDING =>
      val r = CANCEL_PENDING
      r
    case software.amazon.awssdk.services.emr.model.StepState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.StepState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.emr.model.StepState.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.emr.model.StepState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.emr.model.StepState.INTERRUPTED =>
      val r = INTERRUPTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.PENDING
  }
  case object CANCEL_PENDING extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.CANCEL_PENDING
  }
  case object RUNNING extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.RUNNING
  }
  case object COMPLETED extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.COMPLETED
  }
  case object CANCELLED extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.CANCELLED
  }
  case object FAILED extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.FAILED
  }
  case object INTERRUPTED extends zio.aws.emr.model.StepState {
    override def unwrap: software.amazon.awssdk.services.emr.model.StepState =
      software.amazon.awssdk.services.emr.model.StepState.INTERRUPTED
  }
}
