package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait SpotProvisioningAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy
}
object SpotProvisioningAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy
  ): zio.aws.emr.model.SpotProvisioningAllocationStrategy = value match {
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED =>
      val r = `capacity-optimized`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `capacity-optimized`
      extends zio.aws.emr.model.SpotProvisioningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy =
      software.amazon.awssdk.services.emr.model.SpotProvisioningAllocationStrategy.CAPACITY_OPTIMIZED
  }
}
