package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Integer, InstanceType, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceGroupConfig(
    name: Option[XmlStringMaxLen256] = None,
    market: Option[zio.aws.emr.model.MarketType] = None,
    instanceRole: zio.aws.emr.model.InstanceRoleType,
    bidPrice: Option[XmlStringMaxLen256] = None,
    instanceType: InstanceType,
    instanceCount: Integer,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None,
    ebsConfiguration: Option[zio.aws.emr.model.EbsConfiguration] = None,
    autoScalingPolicy: Option[zio.aws.emr.model.AutoScalingPolicy] = None,
    customAmiId: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroupConfig = {
    import InstanceGroupConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroupConfig
      .builder()
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .instanceRole(instanceRole.unwrap)
      .optionallyWith(
        bidPrice.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.bidPrice)
      .instanceType(InstanceType.unwrap(instanceType): java.lang.String)
      .instanceCount(Integer.unwrap(instanceCount): java.lang.Integer)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(ebsConfiguration.map(value => value.buildAwsValue()))(
        _.ebsConfiguration
      )
      .optionallyWith(autoScalingPolicy.map(value => value.buildAwsValue()))(
        _.autoScalingPolicy
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroupConfig.ReadOnly =
    zio.aws.emr.model.InstanceGroupConfig.wrap(buildAwsValue())
}
object InstanceGroupConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceGroupConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroupConfig =
      zio.aws.emr.model.InstanceGroupConfig(
        name.map(value => value),
        market.map(value => value),
        instanceRole,
        bidPrice.map(value => value),
        instanceType,
        instanceCount,
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsConfiguration.map(value => value.asEditable),
        autoScalingPolicy.map(value => value.asEditable),
        customAmiId.map(value => value)
      )
    def name: Option[XmlStringMaxLen256]
    def market: Option[zio.aws.emr.model.MarketType]
    def instanceRole: zio.aws.emr.model.InstanceRoleType
    def bidPrice: Option[XmlStringMaxLen256]
    def instanceType: InstanceType
    def instanceCount: Integer
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def ebsConfiguration: Option[zio.aws.emr.model.EbsConfiguration.ReadOnly]
    def autoScalingPolicy: Option[zio.aws.emr.model.AutoScalingPolicy.ReadOnly]
    def customAmiId: Option[XmlStringMaxLen256]
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getInstanceRole: ZIO[Any, Nothing, zio.aws.emr.model.InstanceRoleType] =
      ZIO.succeed(instanceRole)
    def getBidPrice: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getInstanceType: ZIO[Any, Nothing, InstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getEbsConfiguration
        : ZIO[Any, AwsError, zio.aws.emr.model.EbsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("ebsConfiguration", ebsConfiguration)
    def getAutoScalingPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.AutoScalingPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoScalingPolicy", autoScalingPolicy)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupConfig
  ) extends zio.aws.emr.model.InstanceGroupConfig.ReadOnly {
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val market: Option[zio.aws.emr.model.MarketType] = scala
      .Option(impl.market())
      .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val instanceRole: zio.aws.emr.model.InstanceRoleType =
      zio.aws.emr.model.InstanceRoleType.wrap(impl.instanceRole())
    override val bidPrice: Option[XmlStringMaxLen256] = scala
      .Option(impl.bidPrice())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceType: InstanceType =
      zio.aws.emr.model.primitives.InstanceType(impl.instanceType())
    override val instanceCount: Integer =
      zio.aws.emr.model.primitives.Integer(impl.instanceCount())
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val ebsConfiguration
        : Option[zio.aws.emr.model.EbsConfiguration.ReadOnly] = scala
      .Option(impl.ebsConfiguration())
      .map(value => zio.aws.emr.model.EbsConfiguration.wrap(value))
    override val autoScalingPolicy
        : Option[zio.aws.emr.model.AutoScalingPolicy.ReadOnly] = scala
      .Option(impl.autoScalingPolicy())
      .map(value => zio.aws.emr.model.AutoScalingPolicy.wrap(value))
    override val customAmiId: Option[XmlStringMaxLen256] = scala
      .Option(impl.customAmiId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupConfig
  ): zio.aws.emr.model.InstanceGroupConfig.ReadOnly = new Wrapper(impl)
}
