package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  InstanceGroupId,
  BooleanObject,
  InstanceType,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceGroup(
    id: Option[InstanceGroupId] = None,
    name: Option[String] = None,
    market: Option[zio.aws.emr.model.MarketType] = None,
    instanceGroupType: Option[zio.aws.emr.model.InstanceGroupType] = None,
    bidPrice: Option[String] = None,
    instanceType: Option[InstanceType] = None,
    requestedInstanceCount: Option[Integer] = None,
    runningInstanceCount: Option[Integer] = None,
    status: Option[zio.aws.emr.model.InstanceGroupStatus] = None,
    configurations: Option[Iterable[zio.aws.emr.model.Configuration]] = None,
    configurationsVersion: Option[Long] = None,
    lastSuccessfullyAppliedConfigurations: Option[
      Iterable[zio.aws.emr.model.Configuration]
    ] = None,
    lastSuccessfullyAppliedConfigurationsVersion: Option[Long] = None,
    ebsBlockDevices: Option[Iterable[zio.aws.emr.model.EbsBlockDevice]] = None,
    ebsOptimized: Option[BooleanObject] = None,
    shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy] = None,
    autoScalingPolicy: Option[zio.aws.emr.model.AutoScalingPolicyDescription] =
      None,
    customAmiId: Option[XmlStringMaxLen256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroup = {
    import InstanceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroup
      .builder()
      .optionallyWith(
        id.map(value => InstanceGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .optionallyWith(instanceGroupType.map(value => value.unwrap))(
        _.instanceGroupType
      )
      .optionallyWith(bidPrice.map(value => value: java.lang.String))(
        _.bidPrice
      )
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        requestedInstanceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.requestedInstanceCount)
      .optionallyWith(
        runningInstanceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.runningInstanceCount)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        configurationsVersion.map(value => value: java.lang.Long)
      )(_.configurationsVersion)
      .optionallyWith(
        lastSuccessfullyAppliedConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastSuccessfullyAppliedConfigurations)
      .optionallyWith(
        lastSuccessfullyAppliedConfigurationsVersion.map(value =>
          value: java.lang.Long
        )
      )(_.lastSuccessfullyAppliedConfigurationsVersion)
      .optionallyWith(
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsBlockDevices)
      .optionallyWith(
        ebsOptimized.map(value =>
          BooleanObject.unwrap(value): java.lang.Boolean
        )
      )(_.ebsOptimized)
      .optionallyWith(shrinkPolicy.map(value => value.buildAwsValue()))(
        _.shrinkPolicy
      )
      .optionallyWith(autoScalingPolicy.map(value => value.buildAwsValue()))(
        _.autoScalingPolicy
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroup.ReadOnly =
    zio.aws.emr.model.InstanceGroup.wrap(buildAwsValue())
}
object InstanceGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.InstanceGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroup =
      zio.aws.emr.model.InstanceGroup(
        id.map(value => value),
        name.map(value => value),
        market.map(value => value),
        instanceGroupType.map(value => value),
        bidPrice.map(value => value),
        instanceType.map(value => value),
        requestedInstanceCount.map(value => value),
        runningInstanceCount.map(value => value),
        status.map(value => value.asEditable),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationsVersion.map(value => value),
        lastSuccessfullyAppliedConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastSuccessfullyAppliedConfigurationsVersion.map(value => value),
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        shrinkPolicy.map(value => value.asEditable),
        autoScalingPolicy.map(value => value.asEditable),
        customAmiId.map(value => value)
      )
    def id: Option[InstanceGroupId]
    def name: Option[String]
    def market: Option[zio.aws.emr.model.MarketType]
    def instanceGroupType: Option[zio.aws.emr.model.InstanceGroupType]
    def bidPrice: Option[String]
    def instanceType: Option[InstanceType]
    def requestedInstanceCount: Option[Integer]
    def runningInstanceCount: Option[Integer]
    def status: Option[zio.aws.emr.model.InstanceGroupStatus.ReadOnly]
    def configurations: Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def configurationsVersion: Option[Long]
    def lastSuccessfullyAppliedConfigurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def lastSuccessfullyAppliedConfigurationsVersion: Option[Long]
    def ebsBlockDevices: Option[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]]
    def ebsOptimized: Option[BooleanObject]
    def shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy.ReadOnly]
    def autoScalingPolicy
        : Option[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly]
    def customAmiId: Option[XmlStringMaxLen256]
    def getId: ZIO[Any, AwsError, InstanceGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getInstanceGroupType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupType] =
      AwsError.unwrapOptionField("instanceGroupType", instanceGroupType)
    def getBidPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getRequestedInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("requestedInstanceCount", requestedInstanceCount)
    def getRunningInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningInstanceCount", runningInstanceCount)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getConfigurationsVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("configurationsVersion", configurationsVersion)
    def getLastSuccessfullyAppliedConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField(
        "lastSuccessfullyAppliedConfigurations",
        lastSuccessfullyAppliedConfigurations
      )
    def getLastSuccessfullyAppliedConfigurationsVersion
        : ZIO[Any, AwsError, Long] = AwsError.unwrapOptionField(
      "lastSuccessfullyAppliedConfigurationsVersion",
      lastSuccessfullyAppliedConfigurationsVersion
    )
    def getEbsBlockDevices
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      AwsError.unwrapOptionField("ebsBlockDevices", ebsBlockDevices)
    def getEbsOptimized: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getShrinkPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      AwsError.unwrapOptionField("shrinkPolicy", shrinkPolicy)
    def getAutoScalingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField("autoScalingPolicy", autoScalingPolicy)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroup
  ) extends zio.aws.emr.model.InstanceGroup.ReadOnly {
    override val id: Option[InstanceGroupId] = scala
      .Option(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceGroupId(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val market: Option[zio.aws.emr.model.MarketType] = scala
      .Option(impl.market())
      .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val instanceGroupType
        : Option[zio.aws.emr.model.InstanceGroupType] = scala
      .Option(impl.instanceGroupType())
      .map(value => zio.aws.emr.model.InstanceGroupType.wrap(value))
    override val bidPrice: Option[String] =
      scala.Option(impl.bidPrice()).map(value => value: String)
    override val instanceType: Option[InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val requestedInstanceCount: Option[Integer] = scala
      .Option(impl.requestedInstanceCount())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val runningInstanceCount: Option[Integer] = scala
      .Option(impl.runningInstanceCount())
      .map(value => zio.aws.emr.model.primitives.Integer(value))
    override val status
        : Option[zio.aws.emr.model.InstanceGroupStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.emr.model.InstanceGroupStatus.wrap(value))
    override val configurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.configurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val configurationsVersion: Option[Long] =
      scala.Option(impl.configurationsVersion()).map(value => value: Long)
    override val lastSuccessfullyAppliedConfigurations
        : Option[List[zio.aws.emr.model.Configuration.ReadOnly]] = scala
      .Option(impl.lastSuccessfullyAppliedConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Configuration.wrap(item)
        }.toList
      )
    override val lastSuccessfullyAppliedConfigurationsVersion: Option[Long] =
      scala
        .Option(impl.lastSuccessfullyAppliedConfigurationsVersion())
        .map(value => value: Long)
    override val ebsBlockDevices
        : Option[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] = scala
      .Option(impl.ebsBlockDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.EbsBlockDevice.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[BooleanObject] = scala
      .Option(impl.ebsOptimized())
      .map(value => zio.aws.emr.model.primitives.BooleanObject(value))
    override val shrinkPolicy: Option[zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      scala
        .Option(impl.shrinkPolicy())
        .map(value => zio.aws.emr.model.ShrinkPolicy.wrap(value))
    override val autoScalingPolicy
        : Option[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly] =
      scala
        .Option(impl.autoScalingPolicy())
        .map(value =>
          zio.aws.emr.model.AutoScalingPolicyDescription.wrap(value)
        )
    override val customAmiId: Option[XmlStringMaxLen256] = scala
      .Option(impl.customAmiId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroup
  ): zio.aws.emr.model.InstanceGroup.ReadOnly = new Wrapper(impl)
}
