package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStudioRequest(studioId: XmlStringMaxLen256) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DeleteStudioRequest = {
    import DeleteStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DeleteStudioRequest
      .builder()
      .studioId(XmlStringMaxLen256.unwrap(studioId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DeleteStudioRequest.ReadOnly =
    zio.aws.emr.model.DeleteStudioRequest.wrap(buildAwsValue())
}
object DeleteStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DeleteStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DeleteStudioRequest =
      zio.aws.emr.model.DeleteStudioRequest(studioId)
    def studioId: XmlStringMaxLen256
    def getStudioId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DeleteStudioRequest
  ) extends zio.aws.emr.model.DeleteStudioRequest.ReadOnly {
    override val studioId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.studioId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DeleteStudioRequest
  ): zio.aws.emr.model.DeleteStudioRequest.ReadOnly = new Wrapper(impl)
}
