package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelStepsResponse(
    cancelStepsInfoList: Option[Iterable[zio.aws.emr.model.CancelStepsInfo]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.CancelStepsResponse = {
    import CancelStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.CancelStepsResponse
      .builder()
      .optionallyWith(
        cancelStepsInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cancelStepsInfoList)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.CancelStepsResponse.ReadOnly =
    zio.aws.emr.model.CancelStepsResponse.wrap(buildAwsValue())
}
object CancelStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.CancelStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.CancelStepsResponse =
      zio.aws.emr.model.CancelStepsResponse(
        cancelStepsInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cancelStepsInfoList
        : Option[List[zio.aws.emr.model.CancelStepsInfo.ReadOnly]]
    def getCancelStepsInfoList
        : ZIO[Any, AwsError, List[zio.aws.emr.model.CancelStepsInfo.ReadOnly]] =
      AwsError.unwrapOptionField("cancelStepsInfoList", cancelStepsInfoList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsResponse
  ) extends zio.aws.emr.model.CancelStepsResponse.ReadOnly {
    override val cancelStepsInfoList
        : Option[List[zio.aws.emr.model.CancelStepsInfo.ReadOnly]] = scala
      .Option(impl.cancelStepsInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.CancelStepsInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.CancelStepsResponse
  ): zio.aws.emr.model.CancelStepsResponse.ReadOnly = new Wrapper(impl)
}
