package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  ArnType,
  InstanceFleetId,
  XmlStringMaxLen256
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddInstanceFleetResponse(
    clusterId: Option[XmlStringMaxLen256] = None,
    instanceFleetId: Option[InstanceFleetId] = None,
    clusterArn: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse = {
    import AddInstanceFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
      .builder()
      .optionallyWith(
        clusterId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.clusterId)
      .optionallyWith(
        instanceFleetId.map(value =>
          InstanceFleetId.unwrap(value): java.lang.String
        )
      )(_.instanceFleetId)
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly =
    zio.aws.emr.model.AddInstanceFleetResponse.wrap(buildAwsValue())
}
object AddInstanceFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceFleetResponse =
      zio.aws.emr.model.AddInstanceFleetResponse(
        clusterId.map(value => value),
        instanceFleetId.map(value => value),
        clusterArn.map(value => value)
      )
    def clusterId: Option[XmlStringMaxLen256]
    def instanceFleetId: Option[InstanceFleetId]
    def clusterArn: Option[ArnType]
    def getClusterId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getInstanceFleetId: ZIO[Any, AwsError, InstanceFleetId] =
      AwsError.unwrapOptionField("instanceFleetId", instanceFleetId)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ) extends zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly {
    override val clusterId: Option[XmlStringMaxLen256] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instanceFleetId: Option[InstanceFleetId] = scala
      .Option(impl.instanceFleetId())
      .map(value => zio.aws.emr.model.primitives.InstanceFleetId(value))
    override val clusterArn: Option[ArnType] = scala
      .Option(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse
  ): zio.aws.emr.model.AddInstanceFleetResponse.ReadOnly = new Wrapper(impl)
}
