package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStudioRequest(
    studioId: XmlStringMaxLen256,
    name: Option[XmlStringMaxLen256] = None,
    description: Option[XmlStringMaxLen256] = None,
    subnetIds: Option[Iterable[String]] = None,
    defaultS3Location: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.UpdateStudioRequest = {
    import UpdateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.UpdateStudioRequest
      .builder()
      .studioId(XmlStringMaxLen256.unwrap(studioId): java.lang.String)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        defaultS3Location.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.defaultS3Location)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.UpdateStudioRequest.ReadOnly =
    zio.aws.emr.model.UpdateStudioRequest.wrap(buildAwsValue())
}
object UpdateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.UpdateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.UpdateStudioRequest =
      zio.aws.emr.model.UpdateStudioRequest(
        studioId,
        name.map(value => value),
        description.map(value => value),
        subnetIds.map(value => value),
        defaultS3Location.map(value => value)
      )
    def studioId: XmlStringMaxLen256
    def name: Option[XmlStringMaxLen256]
    def description: Option[XmlStringMaxLen256]
    def subnetIds: Option[List[String]]
    def defaultS3Location: Option[XmlString]
    def getStudioId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(studioId)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getDefaultS3Location: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("defaultS3Location", defaultS3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.UpdateStudioRequest
  ) extends zio.aws.emr.model.UpdateStudioRequest.ReadOnly {
    override val studioId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.studioId())
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val description: Option[XmlStringMaxLen256] = scala
      .Option(impl.description())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val defaultS3Location: Option[XmlString] = scala
      .Option(impl.defaultS3Location())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.UpdateStudioRequest
  ): zio.aws.emr.model.UpdateStudioRequest.ReadOnly = new Wrapper(impl)
}
