package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Date, XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Studio(
    studioId: Option[XmlStringMaxLen256] = None,
    studioArn: Option[XmlStringMaxLen256] = None,
    name: Option[XmlStringMaxLen256] = None,
    description: Option[XmlStringMaxLen256] = None,
    authMode: Option[zio.aws.emr.model.AuthMode] = None,
    vpcId: Option[XmlStringMaxLen256] = None,
    subnetIds: Option[Iterable[String]] = None,
    serviceRole: Option[XmlString] = None,
    userRole: Option[XmlString] = None,
    workspaceSecurityGroupId: Option[XmlStringMaxLen256] = None,
    engineSecurityGroupId: Option[XmlStringMaxLen256] = None,
    url: Option[XmlString] = None,
    creationTime: Option[Date] = None,
    defaultS3Location: Option[XmlString] = None,
    idpAuthUrl: Option[XmlString] = None,
    idpRelayStateParameterName: Option[XmlStringMaxLen256] = None,
    tags: Option[Iterable[zio.aws.emr.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Studio = {
    import Studio.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Studio
      .builder()
      .optionallyWith(
        studioId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioId)
      .optionallyWith(
        studioArn.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.studioArn)
      .optionallyWith(
        name.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(authMode.map(value => value.unwrap))(_.authMode)
      .optionallyWith(
        vpcId.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        serviceRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        userRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.userRole)
      .optionallyWith(
        workspaceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.workspaceSecurityGroupId)
      .optionallyWith(
        engineSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.engineSecurityGroupId)
      .optionallyWith(
        url.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        defaultS3Location.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.defaultS3Location)
      .optionallyWith(
        idpAuthUrl.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.idpAuthUrl)
      .optionallyWith(
        idpRelayStateParameterName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.idpRelayStateParameterName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Studio.ReadOnly =
    zio.aws.emr.model.Studio.wrap(buildAwsValue())
}
object Studio {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Studio] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Studio = zio.aws.emr.model.Studio(
      studioId.map(value => value),
      studioArn.map(value => value),
      name.map(value => value),
      description.map(value => value),
      authMode.map(value => value),
      vpcId.map(value => value),
      subnetIds.map(value => value),
      serviceRole.map(value => value),
      userRole.map(value => value),
      workspaceSecurityGroupId.map(value => value),
      engineSecurityGroupId.map(value => value),
      url.map(value => value),
      creationTime.map(value => value),
      defaultS3Location.map(value => value),
      idpAuthUrl.map(value => value),
      idpRelayStateParameterName.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def studioId: Option[XmlStringMaxLen256]
    def studioArn: Option[XmlStringMaxLen256]
    def name: Option[XmlStringMaxLen256]
    def description: Option[XmlStringMaxLen256]
    def authMode: Option[zio.aws.emr.model.AuthMode]
    def vpcId: Option[XmlStringMaxLen256]
    def subnetIds: Option[List[String]]
    def serviceRole: Option[XmlString]
    def userRole: Option[XmlString]
    def workspaceSecurityGroupId: Option[XmlStringMaxLen256]
    def engineSecurityGroupId: Option[XmlStringMaxLen256]
    def url: Option[XmlString]
    def creationTime: Option[Date]
    def defaultS3Location: Option[XmlString]
    def idpAuthUrl: Option[XmlString]
    def idpRelayStateParameterName: Option[XmlStringMaxLen256]
    def tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]]
    def getStudioId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getStudioArn: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("studioArn", studioArn)
    def getName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("description", description)
    def getAuthMode: ZIO[Any, AwsError, zio.aws.emr.model.AuthMode] =
      AwsError.unwrapOptionField("authMode", authMode)
    def getVpcId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getServiceRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getUserRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("userRole", userRole)
    def getWorkspaceSecurityGroupId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "workspaceSecurityGroupId",
        workspaceSecurityGroupId
      )
    def getEngineSecurityGroupId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("engineSecurityGroupId", engineSecurityGroupId)
    def getUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("url", url)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultS3Location: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("defaultS3Location", defaultS3Location)
    def getIdpAuthUrl: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("idpAuthUrl", idpAuthUrl)
    def getIdpRelayStateParameterName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "idpRelayStateParameterName",
        idpRelayStateParameterName
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Studio
  ) extends zio.aws.emr.model.Studio.ReadOnly {
    override val studioId: Option[XmlStringMaxLen256] = scala
      .Option(impl.studioId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val studioArn: Option[XmlStringMaxLen256] = scala
      .Option(impl.studioArn())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val name: Option[XmlStringMaxLen256] = scala
      .Option(impl.name())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val description: Option[XmlStringMaxLen256] = scala
      .Option(impl.description())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val authMode: Option[zio.aws.emr.model.AuthMode] = scala
      .Option(impl.authMode())
      .map(value => zio.aws.emr.model.AuthMode.wrap(value))
    override val vpcId: Option[XmlStringMaxLen256] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val subnetIds: Option[List[String]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceRole: Option[XmlString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val userRole: Option[XmlString] = scala
      .Option(impl.userRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val workspaceSecurityGroupId: Option[XmlStringMaxLen256] = scala
      .Option(impl.workspaceSecurityGroupId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val engineSecurityGroupId: Option[XmlStringMaxLen256] = scala
      .Option(impl.engineSecurityGroupId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val url: Option[XmlString] = scala
      .Option(impl.url())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val defaultS3Location: Option[XmlString] = scala
      .Option(impl.defaultS3Location())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val idpAuthUrl: Option[XmlString] = scala
      .Option(impl.idpAuthUrl())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val idpRelayStateParameterName: Option[XmlStringMaxLen256] = scala
      .Option(impl.idpRelayStateParameterName())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val tags: Option[List[zio.aws.emr.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Studio
  ): zio.aws.emr.model.Studio.ReadOnly = new Wrapper(impl)
}
