package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListReleaseLabelsResponse(
    releaseLabels: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse = {
    import ListReleaseLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse
      .builder()
      .optionallyWith(
        releaseLabels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.releaseLabels)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly =
    zio.aws.emr.model.ListReleaseLabelsResponse.wrap(buildAwsValue())
}
object ListReleaseLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListReleaseLabelsResponse =
      zio.aws.emr.model.ListReleaseLabelsResponse(
        releaseLabels.map(value => value),
        nextToken.map(value => value)
      )
    def releaseLabels: Option[List[String]]
    def nextToken: Option[String]
    def getReleaseLabels: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("releaseLabels", releaseLabels)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse
  ) extends zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly {
    override val releaseLabels: Option[List[String]] = scala
      .Option(impl.releaseLabels())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse
  ): zio.aws.emr.model.ListReleaseLabelsResponse.ReadOnly = new Wrapper(impl)
}
