package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNotebookExecutionResponse(
    notebookExecution: Option[zio.aws.emr.model.NotebookExecution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse = {
    import DescribeNotebookExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse
      .builder()
      .optionallyWith(notebookExecution.map(value => value.buildAwsValue()))(
        _.notebookExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly =
    zio.aws.emr.model.DescribeNotebookExecutionResponse.wrap(buildAwsValue())
}
object DescribeNotebookExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeNotebookExecutionResponse =
      zio.aws.emr.model.DescribeNotebookExecutionResponse(
        notebookExecution.map(value => value.asEditable)
      )
    def notebookExecution: Option[zio.aws.emr.model.NotebookExecution.ReadOnly]
    def getNotebookExecution
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecution.ReadOnly] =
      AwsError.unwrapOptionField("notebookExecution", notebookExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse
  ) extends zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly {
    override val notebookExecution
        : Option[zio.aws.emr.model.NotebookExecution.ReadOnly] = scala
      .Option(impl.notebookExecution())
      .map(value => zio.aws.emr.model.NotebookExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse
  ): zio.aws.emr.model.DescribeNotebookExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
