package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddJobFlowStepsRequest(
    jobFlowId: XmlStringMaxLen256,
    steps: Iterable[zio.aws.emr.model.StepConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest = {
    import AddJobFlowStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest
      .builder()
      .jobFlowId(XmlStringMaxLen256.unwrap(jobFlowId): java.lang.String)
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddJobFlowStepsRequest.ReadOnly =
    zio.aws.emr.model.AddJobFlowStepsRequest.wrap(buildAwsValue())
}
object AddJobFlowStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddJobFlowStepsRequest =
      zio.aws.emr.model.AddJobFlowStepsRequest(
        jobFlowId,
        steps.map { item =>
          item.asEditable
        }
      )
    def jobFlowId: XmlStringMaxLen256
    def steps: List[zio.aws.emr.model.StepConfig.ReadOnly]
    def getJobFlowId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(jobFlowId)
    def getSteps
        : ZIO[Any, Nothing, List[zio.aws.emr.model.StepConfig.ReadOnly]] =
      ZIO.succeed(steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest
  ) extends zio.aws.emr.model.AddJobFlowStepsRequest.ReadOnly {
    override val jobFlowId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.jobFlowId())
    override val steps: List[zio.aws.emr.model.StepConfig.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.emr.model.StepConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest
  ): zio.aws.emr.model.AddJobFlowStepsRequest.ReadOnly = new Wrapper(impl)
}
