package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  AccessControl,
  Grantee,
  GranteeType
}
import scala.jdk.CollectionConverters.*
final case class Permission(
    granteeType: Optional[GranteeType] = Optional.Absent,
    grantee: Optional[Grantee] = Optional.Absent,
    access: Optional[Iterable[AccessControl]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Permission = {
    import Permission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Permission
      .builder()
      .optionallyWith(
        granteeType.map(value => GranteeType.unwrap(value): java.lang.String)
      )(_.granteeType)
      .optionallyWith(
        grantee.map(value => Grantee.unwrap(value): java.lang.String)
      )(_.grantee)
      .optionallyWith(
        access.map(value =>
          value.map { item =>
            AccessControl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.access)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Permission.ReadOnly =
    zio.aws.elastictranscoder.model.Permission.wrap(buildAwsValue())
}
object Permission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Permission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Permission =
      zio.aws.elastictranscoder.model.Permission(
        granteeType.map(value => value),
        grantee.map(value => value),
        access.map(value => value)
      )
    def granteeType: Optional[GranteeType]
    def grantee: Optional[Grantee]
    def access: Optional[List[AccessControl]]
    def getGranteeType: ZIO[Any, AwsError, GranteeType] =
      AwsError.unwrapOptionField("granteeType", granteeType)
    def getGrantee: ZIO[Any, AwsError, Grantee] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getAccess: ZIO[Any, AwsError, List[AccessControl]] =
      AwsError.unwrapOptionField("access", access)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Permission
  ) extends zio.aws.elastictranscoder.model.Permission.ReadOnly {
    override val granteeType: Optional[GranteeType] = zio.aws.core.internal
      .optionalFromNullable(impl.granteeType())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.GranteeType(value)
      )
    override val grantee: Optional[Grantee] = zio.aws.core.internal
      .optionalFromNullable(impl.grantee())
      .map(value => zio.aws.elastictranscoder.model.primitives.Grantee(value))
    override val access: Optional[List[AccessControl]] = zio.aws.core.internal
      .optionalFromNullable(impl.access())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.AccessControl(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Permission
  ): zio.aws.elastictranscoder.model.Permission.ReadOnly = new Wrapper(impl)
}
