package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  CodecOption,
  FrameRate,
  DigitsOrAuto,
  MaxFrameRate,
  FixedGOP,
  KeyframesMaxDist,
  AspectRatio,
  VideoBitRate,
  PaddingPolicy,
  VideoCodec,
  SizingPolicy,
  Resolution
}
import scala.jdk.CollectionConverters.*
final case class VideoParameters(
    codec: Optional[VideoCodec] = Optional.Absent,
    codecOptions: Optional[Map[CodecOption, CodecOption]] = Optional.Absent,
    keyframesMaxDist: Optional[KeyframesMaxDist] = Optional.Absent,
    fixedGOP: Optional[FixedGOP] = Optional.Absent,
    bitRate: Optional[VideoBitRate] = Optional.Absent,
    frameRate: Optional[FrameRate] = Optional.Absent,
    maxFrameRate: Optional[MaxFrameRate] = Optional.Absent,
    resolution: Optional[Resolution] = Optional.Absent,
    aspectRatio: Optional[AspectRatio] = Optional.Absent,
    maxWidth: Optional[DigitsOrAuto] = Optional.Absent,
    maxHeight: Optional[DigitsOrAuto] = Optional.Absent,
    displayAspectRatio: Optional[AspectRatio] = Optional.Absent,
    sizingPolicy: Optional[SizingPolicy] = Optional.Absent,
    paddingPolicy: Optional[PaddingPolicy] = Optional.Absent,
    watermarks: Optional[
      Iterable[zio.aws.elastictranscoder.model.PresetWatermark]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.VideoParameters = {
    import VideoParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
      .builder()
      .optionallyWith(
        codec.map(value => VideoCodec.unwrap(value): java.lang.String)
      )(_.codec)
      .optionallyWith(
        codecOptions.map(value =>
          value
            .map({ case (key, value) =>
              (CodecOption.unwrap(key): java.lang.String) -> (CodecOption
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.codecOptions)
      .optionallyWith(
        keyframesMaxDist.map(value =>
          KeyframesMaxDist.unwrap(value): java.lang.String
        )
      )(_.keyframesMaxDist)
      .optionallyWith(
        fixedGOP.map(value => FixedGOP.unwrap(value): java.lang.String)
      )(_.fixedGOP)
      .optionallyWith(
        bitRate.map(value => VideoBitRate.unwrap(value): java.lang.String)
      )(_.bitRate)
      .optionallyWith(
        frameRate.map(value => FrameRate.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(
        maxFrameRate.map(value => MaxFrameRate.unwrap(value): java.lang.String)
      )(_.maxFrameRate)
      .optionallyWith(
        resolution.map(value => Resolution.unwrap(value): java.lang.String)
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        displayAspectRatio.map(value =>
          AspectRatio.unwrap(value): java.lang.String
        )
      )(_.displayAspectRatio)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .optionallyWith(
        watermarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.watermarks)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.VideoParameters.ReadOnly =
    zio.aws.elastictranscoder.model.VideoParameters.wrap(buildAwsValue())
}
object VideoParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.VideoParameters =
      zio.aws.elastictranscoder.model.VideoParameters(
        codec.map(value => value),
        codecOptions.map(value => value),
        keyframesMaxDist.map(value => value),
        fixedGOP.map(value => value),
        bitRate.map(value => value),
        frameRate.map(value => value),
        maxFrameRate.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        displayAspectRatio.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value),
        watermarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codec: Optional[VideoCodec]
    def codecOptions: Optional[Map[CodecOption, CodecOption]]
    def keyframesMaxDist: Optional[KeyframesMaxDist]
    def fixedGOP: Optional[FixedGOP]
    def bitRate: Optional[VideoBitRate]
    def frameRate: Optional[FrameRate]
    def maxFrameRate: Optional[MaxFrameRate]
    def resolution: Optional[Resolution]
    def aspectRatio: Optional[AspectRatio]
    def maxWidth: Optional[DigitsOrAuto]
    def maxHeight: Optional[DigitsOrAuto]
    def displayAspectRatio: Optional[AspectRatio]
    def sizingPolicy: Optional[SizingPolicy]
    def paddingPolicy: Optional[PaddingPolicy]
    def watermarks: Optional[
      List[zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly]
    ]
    def getCodec: ZIO[Any, AwsError, VideoCodec] =
      AwsError.unwrapOptionField("codec", codec)
    def getCodecOptions: ZIO[Any, AwsError, Map[CodecOption, CodecOption]] =
      AwsError.unwrapOptionField("codecOptions", codecOptions)
    def getKeyframesMaxDist: ZIO[Any, AwsError, KeyframesMaxDist] =
      AwsError.unwrapOptionField("keyframesMaxDist", keyframesMaxDist)
    def getFixedGOP: ZIO[Any, AwsError, FixedGOP] =
      AwsError.unwrapOptionField("fixedGOP", fixedGOP)
    def getBitRate: ZIO[Any, AwsError, VideoBitRate] =
      AwsError.unwrapOptionField("bitRate", bitRate)
    def getFrameRate: ZIO[Any, AwsError, FrameRate] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getMaxFrameRate: ZIO[Any, AwsError, MaxFrameRate] =
      AwsError.unwrapOptionField("maxFrameRate", maxFrameRate)
    def getResolution: ZIO[Any, AwsError, Resolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getDisplayAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("displayAspectRatio", displayAspectRatio)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
    def getWatermarks: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly
    ]] = AwsError.unwrapOptionField("watermarks", watermarks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ) extends zio.aws.elastictranscoder.model.VideoParameters.ReadOnly {
    override val codec: Optional[VideoCodec] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.VideoCodec(value)
      )
    override val codecOptions: Optional[Map[CodecOption, CodecOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codecOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.elastictranscoder.model.primitives.CodecOption(
                key
              ) -> zio.aws.elastictranscoder.model.primitives.CodecOption(value)
            })
            .toMap
        )
    override val keyframesMaxDist: Optional[KeyframesMaxDist] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyframesMaxDist())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.KeyframesMaxDist(value)
        )
    override val fixedGOP: Optional[FixedGOP] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedGOP())
      .map(value => zio.aws.elastictranscoder.model.primitives.FixedGOP(value))
    override val bitRate: Optional[VideoBitRate] = zio.aws.core.internal
      .optionalFromNullable(impl.bitRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.VideoBitRate(value)
      )
    override val frameRate: Optional[FrameRate] = zio.aws.core.internal
      .optionalFromNullable(impl.frameRate())
      .map(value => zio.aws.elastictranscoder.model.primitives.FrameRate(value))
    override val maxFrameRate: Optional[MaxFrameRate] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFrameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.MaxFrameRate(value)
      )
    override val resolution: Optional[Resolution] = zio.aws.core.internal
      .optionalFromNullable(impl.resolution())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Resolution(value)
      )
    override val aspectRatio: Optional[AspectRatio] = zio.aws.core.internal
      .optionalFromNullable(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val maxWidth: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Optional[DigitsOrAuto] = zio.aws.core.internal
      .optionalFromNullable(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val displayAspectRatio: Optional[AspectRatio] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayAspectRatio())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
        )
    override val sizingPolicy: Optional[SizingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Optional[PaddingPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
    override val watermarks: Optional[
      List[zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.watermarks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.PresetWatermark.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ): zio.aws.elastictranscoder.model.VideoParameters.ReadOnly = new Wrapper(
    impl
  )
}
