package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReadPresetResponse(
    preset: Optional[zio.aws.elastictranscoder.model.Preset] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse = {
    import ReadPresetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse
      .builder()
      .optionallyWith(preset.map(value => value.buildAwsValue()))(_.preset)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ReadPresetResponse.wrap(buildAwsValue())
}
object ReadPresetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ReadPresetResponse =
      zio.aws.elastictranscoder.model
        .ReadPresetResponse(preset.map(value => value.asEditable))
    def preset: Optional[zio.aws.elastictranscoder.model.Preset.ReadOnly]
    def getPreset
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Preset.ReadOnly] =
      AwsError.unwrapOptionField("preset", preset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse
  ) extends zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly {
    override val preset
        : Optional[zio.aws.elastictranscoder.model.Preset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preset())
        .map(value => zio.aws.elastictranscoder.model.Preset.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse
  ): zio.aws.elastictranscoder.model.ReadPresetResponse.ReadOnly = new Wrapper(
    impl
  )
}
