package zio.aws.elastictranscoder.model
import zio.aws.elastictranscoder.model.primitives.{
  NullableLong,
  FloatString,
  NullableInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DetectedProperties(
    width: Optional[NullableInteger] = Optional.Absent,
    height: Optional[NullableInteger] = Optional.Absent,
    frameRate: Optional[FloatString] = Optional.Absent,
    fileSize: Optional[NullableLong] = Optional.Absent,
    durationMillis: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties = {
    import DetectedProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
      .builder()
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .optionallyWith(
        frameRate.map(value => FloatString.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize)
      .optionallyWith(durationMillis.map(value => value: java.lang.Long))(
        _.durationMillis
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly =
    zio.aws.elastictranscoder.model.DetectedProperties.wrap(buildAwsValue())
}
object DetectedProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.DetectedProperties =
      zio.aws.elastictranscoder.model.DetectedProperties(
        width.map(value => value),
        height.map(value => value),
        frameRate.map(value => value),
        fileSize.map(value => value),
        durationMillis.map(value => value)
      )
    def width: Optional[NullableInteger]
    def height: Optional[NullableInteger]
    def frameRate: Optional[FloatString]
    def fileSize: Optional[NullableLong]
    def durationMillis: Optional[NullableLong]
    def getWidth: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("height", height)
    def getFrameRate: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFileSize: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("fileSize", fileSize)
    def getDurationMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ) extends zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly {
    override val width: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.width())
      .map(value => value: NullableInteger)
    override val height: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.height())
      .map(value => value: NullableInteger)
    override val frameRate: Optional[FloatString] = zio.aws.core.internal
      .optionalFromNullable(impl.frameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val fileSize: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSize())
      .map(value => value: NullableLong)
    override val durationMillis: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties
  ): zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly = new Wrapper(
    impl
  )
}
