package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class DeletePipelineRequest(id: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.DeletePipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.DeletePipelineRequest =
      zio.aws.elastictranscoder.model.DeletePipelineRequest(id)
    def id: Id
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest
  ) extends zio.aws.elastictranscoder.model.DeletePipelineRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest
  ): zio.aws.elastictranscoder.model.DeletePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
