package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  ZeroTo255String,
  Base64EncodedString,
  EncryptionMode
}
import scala.jdk.CollectionConverters.*
final case class Encryption(
    mode: Optional[EncryptionMode] = Optional.Absent,
    key: Optional[Base64EncodedString] = Optional.Absent,
    keyMd5: Optional[Base64EncodedString] = Optional.Absent,
    initializationVector: Optional[ZeroTo255String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Encryption = {
    import Encryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Encryption
      .builder()
      .optionallyWith(
        mode.map(value => EncryptionMode.unwrap(value): java.lang.String)
      )(_.mode)
      .optionallyWith(
        key.map(value => Base64EncodedString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        keyMd5.map(value => Base64EncodedString.unwrap(value): java.lang.String)
      )(_.keyMd5)
      .optionallyWith(
        initializationVector.map(value =>
          ZeroTo255String.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Encryption.ReadOnly =
    zio.aws.elastictranscoder.model.Encryption.wrap(buildAwsValue())
}
object Encryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Encryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Encryption =
      zio.aws.elastictranscoder.model.Encryption(
        mode.map(value => value),
        key.map(value => value),
        keyMd5.map(value => value),
        initializationVector.map(value => value)
      )
    def mode: Optional[EncryptionMode]
    def key: Optional[Base64EncodedString]
    def keyMd5: Optional[Base64EncodedString]
    def initializationVector: Optional[ZeroTo255String]
    def getMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getKey: ZIO[Any, AwsError, Base64EncodedString] =
      AwsError.unwrapOptionField("key", key)
    def getKeyMd5: ZIO[Any, AwsError, Base64EncodedString] =
      AwsError.unwrapOptionField("keyMd5", keyMd5)
    def getInitializationVector: ZIO[Any, AwsError, ZeroTo255String] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Encryption
  ) extends zio.aws.elastictranscoder.model.Encryption.ReadOnly {
    override val mode: Optional[EncryptionMode] = zio.aws.core.internal
      .optionalFromNullable(impl.mode())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.EncryptionMode(value)
      )
    override val key: Optional[Base64EncodedString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Base64EncodedString(value)
      )
    override val keyMd5: Optional[Base64EncodedString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyMd5())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Base64EncodedString(value)
      )
    override val initializationVector: Optional[ZeroTo255String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationVector())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.ZeroTo255String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Encryption
  ): zio.aws.elastictranscoder.model.Encryption.ReadOnly = new Wrapper(impl)
}
