package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.NullableLong
import scala.jdk.CollectionConverters.*
final case class Timing(
    submitTimeMillis: Optional[NullableLong] = Optional.Absent,
    startTimeMillis: Optional[NullableLong] = Optional.Absent,
    finishTimeMillis: Optional[NullableLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Timing = {
    import Timing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Timing
      .builder()
      .optionallyWith(submitTimeMillis.map(value => value: java.lang.Long))(
        _.submitTimeMillis
      )
      .optionallyWith(startTimeMillis.map(value => value: java.lang.Long))(
        _.startTimeMillis
      )
      .optionallyWith(finishTimeMillis.map(value => value: java.lang.Long))(
        _.finishTimeMillis
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Timing.ReadOnly =
    zio.aws.elastictranscoder.model.Timing.wrap(buildAwsValue())
}
object Timing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Timing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Timing =
      zio.aws.elastictranscoder.model.Timing(
        submitTimeMillis.map(value => value),
        startTimeMillis.map(value => value),
        finishTimeMillis.map(value => value)
      )
    def submitTimeMillis: Optional[NullableLong]
    def startTimeMillis: Optional[NullableLong]
    def finishTimeMillis: Optional[NullableLong]
    def getSubmitTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("submitTimeMillis", submitTimeMillis)
    def getStartTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("startTimeMillis", startTimeMillis)
    def getFinishTimeMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("finishTimeMillis", finishTimeMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Timing
  ) extends zio.aws.elastictranscoder.model.Timing.ReadOnly {
    override val submitTimeMillis: Optional[NullableLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.submitTimeMillis())
        .map(value => value: NullableLong)
    override val startTimeMillis: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimeMillis())
      .map(value => value: NullableLong)
    override val finishTimeMillis: Optional[NullableLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finishTimeMillis())
        .map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Timing
  ): zio.aws.elastictranscoder.model.Timing.ReadOnly = new Wrapper(impl)
}
