package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{Id, Ascending, JobStatus}
import scala.jdk.CollectionConverters.*
final case class ListJobsByStatusRequest(
    status: JobStatus,
    ascending: Optional[Ascending] = Optional.Absent,
    pageToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest = {
    import ListJobsByStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest
      .builder()
      .status(JobStatus.unwrap(status): java.lang.String)
      .optionallyWith(
        ascending.map(value => Ascending.unwrap(value): java.lang.String)
      )(_.ascending)
      .optionallyWith(
        pageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.ListJobsByStatusRequest.ReadOnly =
    zio.aws.elastictranscoder.model.ListJobsByStatusRequest
      .wrap(buildAwsValue())
}
object ListJobsByStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListJobsByStatusRequest =
      zio.aws.elastictranscoder.model.ListJobsByStatusRequest(
        status,
        ascending.map(value => value),
        pageToken.map(value => value)
      )
    def status: JobStatus
    def ascending: Optional[Ascending]
    def pageToken: Optional[Id]
    def getStatus: ZIO[Any, Nothing, JobStatus] = ZIO.succeed(status)
    def getAscending: ZIO[Any, AwsError, Ascending] =
      AwsError.unwrapOptionField("ascending", ascending)
    def getPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest
  ) extends zio.aws.elastictranscoder.model.ListJobsByStatusRequest.ReadOnly {
    override val status: JobStatus =
      zio.aws.elastictranscoder.model.primitives.JobStatus(impl.status())
    override val ascending: Optional[Ascending] = zio.aws.core.internal
      .optionalFromNullable(impl.ascending())
      .map(value => zio.aws.elastictranscoder.model.primitives.Ascending(value))
    override val pageToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest
  ): zio.aws.elastictranscoder.model.ListJobsByStatusRequest.ReadOnly =
    new Wrapper(impl)
}
