package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  KeyArn,
  Role,
  BucketName,
  Name
}
import scala.jdk.CollectionConverters.*
final case class CreatePipelineRequest(
    name: Name,
    inputBucket: BucketName,
    outputBucket: Optional[BucketName] = Optional.Absent,
    role: Role,
    awsKmsKeyArn: Optional[KeyArn] = Optional.Absent,
    notifications: Optional[zio.aws.elastictranscoder.model.Notifications] =
      Optional.Absent,
    contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = Optional.Absent,
    thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .inputBucket(BucketName.unwrap(inputBucket): java.lang.String)
      .optionallyWith(
        outputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.outputBucket)
      .role(Role.unwrap(role): java.lang.String)
      .optionallyWith(
        awsKmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.awsKmsKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(contentConfig.map(value => value.buildAwsValue()))(
        _.contentConfig
      )
      .optionallyWith(thumbnailConfig.map(value => value.buildAwsValue()))(
        _.thumbnailConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePipelineRequest =
      zio.aws.elastictranscoder.model.CreatePipelineRequest(
        name,
        inputBucket,
        outputBucket.map(value => value),
        role,
        awsKmsKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        contentConfig.map(value => value.asEditable),
        thumbnailConfig.map(value => value.asEditable)
      )
    def name: Name
    def inputBucket: BucketName
    def outputBucket: Optional[BucketName]
    def role: Role
    def awsKmsKeyArn: Optional[KeyArn]
    def notifications
        : Optional[zio.aws.elastictranscoder.model.Notifications.ReadOnly]
    def contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ]
    def thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getInputBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(inputBucket)
    def getOutputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("outputBucket", outputBucket)
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getAwsKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("awsKmsKeyArn", awsKmsKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getContentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentConfig", contentConfig)
    def getThumbnailConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailConfig", thumbnailConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ) extends zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly {
    override val name: Name =
      zio.aws.elastictranscoder.model.primitives.Name(impl.name())
    override val inputBucket: BucketName =
      zio.aws.elastictranscoder.model.primitives.BucketName(impl.inputBucket())
    override val outputBucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.outputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val role: Role =
      zio.aws.elastictranscoder.model.primitives.Role(impl.role())
    override val awsKmsKeyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.awsKmsKeyArn())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyArn(value))
    override val notifications
        : Optional[zio.aws.elastictranscoder.model.Notifications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value => zio.aws.elastictranscoder.model.Notifications.wrap(value))
    override val contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
    override val thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.thumbnailConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ): zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
