package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  KeyArn,
  BucketName,
  Name,
  Role,
  Id
}
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineRequest(
    id: Id,
    name: Optional[Name] = Optional.Absent,
    inputBucket: Optional[BucketName] = Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    awsKmsKeyArn: Optional[KeyArn] = Optional.Absent,
    notifications: Optional[zio.aws.elastictranscoder.model.Notifications] =
      Optional.Absent,
    contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = Optional.Absent,
    thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest = {
    import UpdatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        inputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.inputBucket)
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        awsKmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.awsKmsKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(contentConfig.map(value => value.buildAwsValue()))(
        _.contentConfig
      )
      .optionallyWith(thumbnailConfig.map(value => value.buildAwsValue()))(
        _.thumbnailConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineRequest.wrap(buildAwsValue())
}
object UpdatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.UpdatePipelineRequest =
      zio.aws.elastictranscoder.model.UpdatePipelineRequest(
        id,
        name.map(value => value),
        inputBucket.map(value => value),
        role.map(value => value),
        awsKmsKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        contentConfig.map(value => value.asEditable),
        thumbnailConfig.map(value => value.asEditable)
      )
    def id: Id
    def name: Optional[Name]
    def inputBucket: Optional[BucketName]
    def role: Optional[Role]
    def awsKmsKeyArn: Optional[KeyArn]
    def notifications
        : Optional[zio.aws.elastictranscoder.model.Notifications.ReadOnly]
    def contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ]
    def thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getInputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("inputBucket", inputBucket)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getAwsKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("awsKmsKeyArn", awsKmsKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getContentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentConfig", contentConfig)
    def getThumbnailConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailConfig", thumbnailConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val inputBucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.inputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.elastictranscoder.model.primitives.Role(value))
    override val awsKmsKeyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.awsKmsKeyArn())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyArn(value))
    override val notifications
        : Optional[zio.aws.elastictranscoder.model.Notifications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value => zio.aws.elastictranscoder.model.Notifications.wrap(value))
    override val contentConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
    override val thumbnailConfig: Optional[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.thumbnailConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest
  ): zio.aws.elastictranscoder.model.UpdatePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
