package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{JobStatus, Key, Id}
import scala.jdk.CollectionConverters.*
final case class Job(
    id: Optional[Id] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    pipelineId: Optional[Id] = Optional.Absent,
    input: Optional[zio.aws.elastictranscoder.model.JobInput] = Optional.Absent,
    inputs: Optional[Iterable[zio.aws.elastictranscoder.model.JobInput]] =
      Optional.Absent,
    output: Optional[zio.aws.elastictranscoder.model.JobOutput] =
      Optional.Absent,
    outputs: Optional[Iterable[zio.aws.elastictranscoder.model.JobOutput]] =
      Optional.Absent,
    outputKeyPrefix: Optional[Key] = Optional.Absent,
    playlists: Optional[Iterable[zio.aws.elastictranscoder.model.Playlist]] =
      Optional.Absent,
    status: Optional[JobStatus] = Optional.Absent,
    userMetadata: Optional[Map[String, String]] = Optional.Absent,
    timing: Optional[zio.aws.elastictranscoder.model.Timing] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Job
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        pipelineId.map(value => Id.unwrap(value): java.lang.String)
      )(_.pipelineId)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        outputKeyPrefix.map(value => Key.unwrap(value): java.lang.String)
      )(_.outputKeyPrefix)
      .optionallyWith(
        playlists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playlists)
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        userMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.userMetadata)
      .optionallyWith(timing.map(value => value.buildAwsValue()))(_.timing)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Job.ReadOnly =
    zio.aws.elastictranscoder.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Job
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Job =
      zio.aws.elastictranscoder.model.Job(
        id.map(value => value),
        arn.map(value => value),
        pipelineId.map(value => value),
        input.map(value => value.asEditable),
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        output.map(value => value.asEditable),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputKeyPrefix.map(value => value),
        playlists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        userMetadata.map(value => value),
        timing.map(value => value.asEditable)
      )
    def id: Optional[Id]
    def arn: Optional[String]
    def pipelineId: Optional[Id]
    def input: Optional[zio.aws.elastictranscoder.model.JobInput.ReadOnly]
    def inputs
        : Optional[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]]
    def output: Optional[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]
    def outputs
        : Optional[List[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]]
    def outputKeyPrefix: Optional[Key]
    def playlists
        : Optional[List[zio.aws.elastictranscoder.model.Playlist.ReadOnly]]
    def status: Optional[JobStatus]
    def userMetadata: Optional[Map[String, String]]
    def timing: Optional[zio.aws.elastictranscoder.model.Timing.ReadOnly]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getPipelineId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getOutputKeyPrefix: ZIO[Any, AwsError, Key] =
      AwsError.unwrapOptionField("outputKeyPrefix", outputKeyPrefix)
    def getPlaylists: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Playlist.ReadOnly
    ]] = AwsError.unwrapOptionField("playlists", playlists)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUserMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getTiming
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Timing.ReadOnly] =
      AwsError.unwrapOptionField("timing", timing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Job
  ) extends zio.aws.elastictranscoder.model.Job.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val pipelineId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineId())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val input
        : Optional[zio.aws.elastictranscoder.model.JobInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.input())
        .map(value => zio.aws.elastictranscoder.model.JobInput.wrap(value))
    override val inputs
        : Optional[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobInput.wrap(item)
          }.toList
        )
    override val output
        : Optional[zio.aws.elastictranscoder.model.JobOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.output())
        .map(value => zio.aws.elastictranscoder.model.JobOutput.wrap(value))
    override val outputs
        : Optional[List[zio.aws.elastictranscoder.model.JobOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobOutput.wrap(item)
          }.toList
        )
    override val outputKeyPrefix: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.outputKeyPrefix())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val playlists
        : Optional[List[zio.aws.elastictranscoder.model.Playlist.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playlists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Playlist.wrap(item)
          }.toList
        )
    override val status: Optional[JobStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val userMetadata: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val timing
        : Optional[zio.aws.elastictranscoder.model.Timing.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timing())
        .map(value => zio.aws.elastictranscoder.model.Timing.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Job
  ): zio.aws.elastictranscoder.model.Job.ReadOnly = new Wrapper(impl)
}
