package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePresetResponse(
    preset: Optional[zio.aws.elastictranscoder.model.Preset] = Optional.Absent,
    warning: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse = {
    import CreatePresetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
      .builder()
      .optionallyWith(preset.map(value => value.buildAwsValue()))(_.preset)
      .optionallyWith(warning.map(value => value: java.lang.String))(_.warning)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePresetResponse.wrap(buildAwsValue())
}
object CreatePresetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePresetResponse =
      zio.aws.elastictranscoder.model.CreatePresetResponse(
        preset.map(value => value.asEditable),
        warning.map(value => value)
      )
    def preset: Optional[zio.aws.elastictranscoder.model.Preset.ReadOnly]
    def warning: Optional[String]
    def getPreset
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Preset.ReadOnly] =
      AwsError.unwrapOptionField("preset", preset)
    def getWarning: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warning", warning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ) extends zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly {
    override val preset
        : Optional[zio.aws.elastictranscoder.model.Preset.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preset())
        .map(value => zio.aws.elastictranscoder.model.Preset.wrap(value))
    override val warning: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.warning())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse
  ): zio.aws.elastictranscoder.model.CreatePresetResponse.ReadOnly =
    new Wrapper(impl)
}
