package zio.aws.elastictranscoder.model
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  NullableLong,
  Rotate,
  JobStatus,
  Description,
  FloatString,
  ThumbnailPattern,
  NullableInteger,
  Id
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class JobOutput(
    id: Optional[String] = Optional.Absent,
    key: Optional[Key] = Optional.Absent,
    thumbnailPattern: Optional[ThumbnailPattern] = Optional.Absent,
    thumbnailEncryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent,
    rotate: Optional[Rotate] = Optional.Absent,
    presetId: Optional[Id] = Optional.Absent,
    segmentDuration: Optional[FloatString] = Optional.Absent,
    status: Optional[JobStatus] = Optional.Absent,
    statusDetail: Optional[Description] = Optional.Absent,
    duration: Optional[NullableLong] = Optional.Absent,
    width: Optional[NullableInteger] = Optional.Absent,
    height: Optional[NullableInteger] = Optional.Absent,
    frameRate: Optional[FloatString] = Optional.Absent,
    fileSize: Optional[NullableLong] = Optional.Absent,
    durationMillis: Optional[NullableLong] = Optional.Absent,
    watermarks: Optional[
      Iterable[zio.aws.elastictranscoder.model.JobWatermark]
    ] = Optional.Absent,
    albumArt: Optional[zio.aws.elastictranscoder.model.JobAlbumArt] =
      Optional.Absent,
    composition: Optional[Iterable[zio.aws.elastictranscoder.model.Clip]] =
      Optional.Absent,
    captions: Optional[zio.aws.elastictranscoder.model.Captions] =
      Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent,
    appliedColorSpaceConversion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobOutput = {
    import JobOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobOutput
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        thumbnailPattern.map(value =>
          ThumbnailPattern.unwrap(value): java.lang.String
        )
      )(_.thumbnailPattern)
      .optionallyWith(thumbnailEncryption.map(value => value.buildAwsValue()))(
        _.thumbnailEncryption
      )
      .optionallyWith(
        rotate.map(value => Rotate.unwrap(value): java.lang.String)
      )(_.rotate)
      .optionallyWith(
        presetId.map(value => Id.unwrap(value): java.lang.String)
      )(_.presetId)
      .optionallyWith(
        segmentDuration.map(value =>
          FloatString.unwrap(value): java.lang.String
        )
      )(_.segmentDuration)
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusDetail.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(width.map(value => value: Integer))(_.width)
      .optionallyWith(height.map(value => value: Integer))(_.height)
      .optionallyWith(
        frameRate.map(value => FloatString.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize)
      .optionallyWith(durationMillis.map(value => value: java.lang.Long))(
        _.durationMillis
      )
      .optionallyWith(
        watermarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.watermarks)
      .optionallyWith(albumArt.map(value => value.buildAwsValue()))(_.albumArt)
      .optionallyWith(
        composition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.composition)
      .optionallyWith(captions.map(value => value.buildAwsValue()))(_.captions)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        appliedColorSpaceConversion.map(value => value: java.lang.String)
      )(_.appliedColorSpaceConversion)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobOutput.ReadOnly =
    zio.aws.elastictranscoder.model.JobOutput.wrap(buildAwsValue())
}
object JobOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobOutput =
      zio.aws.elastictranscoder.model.JobOutput(
        id.map(value => value),
        key.map(value => value),
        thumbnailPattern.map(value => value),
        thumbnailEncryption.map(value => value.asEditable),
        rotate.map(value => value),
        presetId.map(value => value),
        segmentDuration.map(value => value),
        status.map(value => value),
        statusDetail.map(value => value),
        duration.map(value => value),
        width.map(value => value),
        height.map(value => value),
        frameRate.map(value => value),
        fileSize.map(value => value),
        durationMillis.map(value => value),
        watermarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        albumArt.map(value => value.asEditable),
        composition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        captions.map(value => value.asEditable),
        encryption.map(value => value.asEditable),
        appliedColorSpaceConversion.map(value => value)
      )
    def id: Optional[String]
    def key: Optional[Key]
    def thumbnailPattern: Optional[ThumbnailPattern]
    def thumbnailEncryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def rotate: Optional[Rotate]
    def presetId: Optional[Id]
    def segmentDuration: Optional[FloatString]
    def status: Optional[JobStatus]
    def statusDetail: Optional[Description]
    def duration: Optional[NullableLong]
    def width: Optional[NullableInteger]
    def height: Optional[NullableInteger]
    def frameRate: Optional[FloatString]
    def fileSize: Optional[NullableLong]
    def durationMillis: Optional[NullableLong]
    def watermarks
        : Optional[List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]]
    def albumArt: Optional[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly]
    def composition
        : Optional[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]]
    def captions: Optional[zio.aws.elastictranscoder.model.Captions.ReadOnly]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def appliedColorSpaceConversion: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getThumbnailPattern: ZIO[Any, AwsError, ThumbnailPattern] =
      AwsError.unwrapOptionField("thumbnailPattern", thumbnailPattern)
    def getThumbnailEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailEncryption", thumbnailEncryption)
    def getRotate: ZIO[Any, AwsError, Rotate] =
      AwsError.unwrapOptionField("rotate", rotate)
    def getPresetId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("presetId", presetId)
    def getSegmentDuration: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("segmentDuration", segmentDuration)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetail: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
    def getDuration: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("duration", duration)
    def getWidth: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("height", height)
    def getFrameRate: ZIO[Any, AwsError, FloatString] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getFileSize: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("fileSize", fileSize)
    def getDurationMillis: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("durationMillis", durationMillis)
    def getWatermarks: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobWatermark.ReadOnly
    ]] = AwsError.unwrapOptionField("watermarks", watermarks)
    def getAlbumArt: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly
    ] = AwsError.unwrapOptionField("albumArt", albumArt)
    def getComposition: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Clip.ReadOnly
    ]] = AwsError.unwrapOptionField("composition", composition)
    def getCaptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Captions.ReadOnly
    ] = AwsError.unwrapOptionField("captions", captions)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getAppliedColorSpaceConversion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "appliedColorSpaceConversion",
        appliedColorSpaceConversion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ) extends zio.aws.elastictranscoder.model.JobOutput.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val thumbnailPattern: Optional[ThumbnailPattern] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnailPattern())
        .map(value =>
          zio.aws.elastictranscoder.model.primitives.ThumbnailPattern(value)
        )
    override val thumbnailEncryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnailEncryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val rotate: Optional[Rotate] = zio.aws.core.internal
      .optionalFromNullable(impl.rotate())
      .map(value => zio.aws.elastictranscoder.model.primitives.Rotate(value))
    override val presetId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.presetId())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val segmentDuration: Optional[FloatString] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentDuration())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val status: Optional[JobStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val statusDetail: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetail())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val duration: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: NullableLong)
    override val width: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.width())
      .map(value => value: NullableInteger)
    override val height: Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.height())
      .map(value => value: NullableInteger)
    override val frameRate: Optional[FloatString] = zio.aws.core.internal
      .optionalFromNullable(impl.frameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.FloatString(value)
      )
    override val fileSize: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSize())
      .map(value => value: NullableLong)
    override val durationMillis: Optional[NullableLong] = zio.aws.core.internal
      .optionalFromNullable(impl.durationMillis())
      .map(value => value: NullableLong)
    override val watermarks: Optional[
      List[zio.aws.elastictranscoder.model.JobWatermark.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.watermarks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.JobWatermark.wrap(item)
        }.toList
      )
    override val albumArt
        : Optional[zio.aws.elastictranscoder.model.JobAlbumArt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.albumArt())
        .map(value => zio.aws.elastictranscoder.model.JobAlbumArt.wrap(value))
    override val composition
        : Optional[List[zio.aws.elastictranscoder.model.Clip.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.composition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Clip.wrap(item)
          }.toList
        )
    override val captions
        : Optional[zio.aws.elastictranscoder.model.Captions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captions())
        .map(value => zio.aws.elastictranscoder.model.Captions.wrap(value))
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val appliedColorSpaceConversion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appliedColorSpaceConversion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobOutput
  ): zio.aws.elastictranscoder.model.JobOutput.ReadOnly = new Wrapper(impl)
}
