package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  PresetType,
  PresetContainer,
  Description,
  Name,
  Id
}
import scala.jdk.CollectionConverters.*
final case class Preset(
    id: Optional[Id] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    container: Optional[PresetContainer] = Optional.Absent,
    audio: Optional[zio.aws.elastictranscoder.model.AudioParameters] =
      Optional.Absent,
    video: Optional[zio.aws.elastictranscoder.model.VideoParameters] =
      Optional.Absent,
    thumbnails: Optional[zio.aws.elastictranscoder.model.Thumbnails] =
      Optional.Absent,
    `type`: Optional[PresetType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Preset = {
    import Preset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Preset
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        container.map(value => PresetContainer.unwrap(value): java.lang.String)
      )(_.container)
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .optionallyWith(thumbnails.map(value => value.buildAwsValue()))(
        _.thumbnails
      )
      .optionallyWith(
        `type`.map(value => PresetType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Preset.ReadOnly =
    zio.aws.elastictranscoder.model.Preset.wrap(buildAwsValue())
}
object Preset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Preset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Preset =
      zio.aws.elastictranscoder.model.Preset(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        container.map(value => value),
        audio.map(value => value.asEditable),
        video.map(value => value.asEditable),
        thumbnails.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def id: Optional[Id]
    def arn: Optional[String]
    def name: Optional[Name]
    def description: Optional[Description]
    def container: Optional[PresetContainer]
    def audio
        : Optional[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly]
    def video
        : Optional[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly]
    def thumbnails
        : Optional[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly]
    def `type`: Optional[PresetType]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContainer: ZIO[Any, AwsError, PresetContainer] =
      AwsError.unwrapOptionField("container", container)
    def getAudio: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.AudioParameters.ReadOnly
    ] = AwsError.unwrapOptionField("audio", audio)
    def getVideo: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.VideoParameters.ReadOnly
    ] = AwsError.unwrapOptionField("video", video)
    def getThumbnails: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Thumbnails.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnails", thumbnails)
    def getType: ZIO[Any, AwsError, PresetType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Preset
  ) extends zio.aws.elastictranscoder.model.Preset.ReadOnly {
    override val id: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
    override val container: Optional[PresetContainer] = zio.aws.core.internal
      .optionalFromNullable(impl.container())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetContainer(value)
      )
    override val audio
        : Optional[zio.aws.elastictranscoder.model.AudioParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audio())
        .map(value =>
          zio.aws.elastictranscoder.model.AudioParameters.wrap(value)
        )
    override val video
        : Optional[zio.aws.elastictranscoder.model.VideoParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value =>
          zio.aws.elastictranscoder.model.VideoParameters.wrap(value)
        )
    override val thumbnails
        : Optional[zio.aws.elastictranscoder.model.Thumbnails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnails())
        .map(value => zio.aws.elastictranscoder.model.Thumbnails.wrap(value))
    override val `type`: Optional[PresetType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PresetType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Preset
  ): zio.aws.elastictranscoder.model.Preset.ReadOnly = new Wrapper(impl)
}
