package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class ListPresetsResponse(
    presets: Optional[Iterable[zio.aws.elastictranscoder.model.Preset]] =
      Optional.Absent,
    nextPageToken: Optional[Id] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse = {
    import ListPresetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse
      .builder()
      .optionallyWith(
        presets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.presets)
      .optionallyWith(
        nextPageToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly =
    zio.aws.elastictranscoder.model.ListPresetsResponse.wrap(buildAwsValue())
}
object ListPresetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.ListPresetsResponse =
      zio.aws.elastictranscoder.model.ListPresetsResponse(
        presets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def presets: Optional[List[zio.aws.elastictranscoder.model.Preset.ReadOnly]]
    def nextPageToken: Optional[Id]
    def getPresets: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Preset.ReadOnly
    ]] = AwsError.unwrapOptionField("presets", presets)
    def getNextPageToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse
  ) extends zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly {
    override val presets
        : Optional[List[zio.aws.elastictranscoder.model.Preset.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.presets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Preset.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => zio.aws.elastictranscoder.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse
  ): zio.aws.elastictranscoder.model.ListPresetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
