package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateJobResponse(
    job: Optional[zio.aws.elastictranscoder.model.Job] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse = {
    import CreateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly =
    zio.aws.elastictranscoder.model.CreateJobResponse.wrap(buildAwsValue())
}
object CreateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreateJobResponse =
      zio.aws.elastictranscoder.model
        .CreateJobResponse(job.map(value => value.asEditable))
    def job: Optional[zio.aws.elastictranscoder.model.Job.ReadOnly]
    def getJob
        : ZIO[Any, AwsError, zio.aws.elastictranscoder.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse
  ) extends zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly {
    override val job: Optional[zio.aws.elastictranscoder.model.Job.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.elastictranscoder.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse
  ): zio.aws.elastictranscoder.model.CreateJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
