package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elastictranscoder.model.primitives.{
  CaptionFormatPattern,
  CaptionFormatFormat
}
import scala.jdk.CollectionConverters.*
final case class CaptionFormat(
    format: Optional[CaptionFormatFormat] = Optional.Absent,
    pattern: Optional[CaptionFormatPattern] = Optional.Absent,
    encryption: Optional[zio.aws.elastictranscoder.model.Encryption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat = {
    import CaptionFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
      .builder()
      .optionallyWith(
        format.map(value => CaptionFormatFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        pattern.map(value =>
          CaptionFormatPattern.unwrap(value): java.lang.String
        )
      )(_.pattern)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly =
    zio.aws.elastictranscoder.model.CaptionFormat.wrap(buildAwsValue())
}
object CaptionFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CaptionFormat =
      zio.aws.elastictranscoder.model.CaptionFormat(
        format.map(value => value),
        pattern.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def format: Optional[CaptionFormatFormat]
    def pattern: Optional[CaptionFormatPattern]
    def encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getFormat: ZIO[Any, AwsError, CaptionFormatFormat] =
      AwsError.unwrapOptionField("format", format)
    def getPattern: ZIO[Any, AwsError, CaptionFormatPattern] =
      AwsError.unwrapOptionField("pattern", pattern)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ) extends zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly {
    override val format: Optional[CaptionFormatFormat] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.CaptionFormatFormat(value)
      )
    override val pattern: Optional[CaptionFormatPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.pattern())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.CaptionFormatPattern(value)
      )
    override val encryption
        : Optional[zio.aws.elastictranscoder.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat
  ): zio.aws.elastictranscoder.model.CaptionFormat.ReadOnly = new Wrapper(impl)
}
