package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineResponse(
    pipeline: Optional[zio.aws.elastictranscoder.model.Pipeline] =
      Optional.Absent,
    warnings: Optional[Iterable[zio.aws.elastictranscoder.model.Warning]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse = {
    import UpdatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineResponse.wrap(buildAwsValue())
}
object UpdatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.UpdatePipelineResponse =
      zio.aws.elastictranscoder.model.UpdatePipelineResponse(
        pipeline.map(value => value.asEditable),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipeline: Optional[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
    def warnings
        : Optional[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getWarnings: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.Warning.ReadOnly
    ]] = AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly {
    override val pipeline
        : Optional[zio.aws.elastictranscoder.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.elastictranscoder.model.Pipeline.wrap(value))
    override val warnings
        : Optional[List[zio.aws.elastictranscoder.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.Warning.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse
  ): zio.aws.elastictranscoder.model.UpdatePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
