package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Clip(
    timeSpan: Optional[zio.aws.elastictranscoder.model.TimeSpan] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Clip = {
    import Clip.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Clip
      .builder()
      .optionallyWith(timeSpan.map(value => value.buildAwsValue()))(_.timeSpan)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Clip.ReadOnly =
    zio.aws.elastictranscoder.model.Clip.wrap(buildAwsValue())
}
object Clip {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Clip
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Clip =
      zio.aws.elastictranscoder.model
        .Clip(timeSpan.map(value => value.asEditable))
    def timeSpan: Optional[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly]
    def getTimeSpan: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.TimeSpan.ReadOnly
    ] = AwsError.unwrapOptionField("timeSpan", timeSpan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Clip
  ) extends zio.aws.elastictranscoder.model.Clip.ReadOnly {
    override val timeSpan
        : Optional[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSpan())
        .map(value => zio.aws.elastictranscoder.model.TimeSpan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Clip
  ): zio.aws.elastictranscoder.model.Clip.ReadOnly = new Wrapper(impl)
}
