package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elastictranscoder.model.primitives.Id
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineNotificationsRequest(
    id: Id,
    notifications: zio.aws.elastictranscoder.model.Notifications
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest = {
    import UpdatePipelineNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
      .builder()
      .id(Id.unwrap(id): java.lang.String)
      .notifications(notifications.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineNotificationsRequest.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineNotificationsRequest
      .wrap(buildAwsValue())
}
object UpdatePipelineNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elastictranscoder.model.UpdatePipelineNotificationsRequest =
      zio.aws.elastictranscoder.model
        .UpdatePipelineNotificationsRequest(id, notifications.asEditable)
    def id: Id
    def notifications: zio.aws.elastictranscoder.model.Notifications.ReadOnly
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getNotifications: ZIO[
      Any,
      Nothing,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = ZIO.succeed(notifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineNotificationsRequest.ReadOnly {
    override val id: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.id())
    override val notifications
        : zio.aws.elastictranscoder.model.Notifications.ReadOnly =
      zio.aws.elastictranscoder.model.Notifications.wrap(impl.notifications())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
  ): zio.aws.elastictranscoder.model.UpdatePipelineNotificationsRequest.ReadOnly =
    new Wrapper(impl)
}
